import{Fragment,h}from"@stencil/core";import{__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{intervalString}from"../../../../functions/price";import{formatTaxDisplay}from"../../../../functions/tax";export class ScOrder{constructor(){this.orderId=void 0,this.customerIds=void 0,this.heading=void 0,this.order=void 0,this.purchases=void 0,this.loading=void 0,this.busy=void 0,this.error=void 0}componentDidLoad(){onFirstVisible(this.el,(()=>{this.fetchOrder(),this.fetchDownloads()}))}async fetchOrder(){try{this.loading=!0,await this.getOrder()}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.loading=!1}}async fetchDownloads(){try{this.busy=!0,this.purchases=await apiFetch({path:addQueryArgs("surecart/v1/purchases",{expand:["product","product.downloads","download.media"],order_ids:[this.orderId],customer_ids:this.customerIds,downloadable:!0})})}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getOrder(){this.order=await apiFetch({path:addQueryArgs(`surecart/v1/orders/${this.orderId}`,{expand:["checkout","checkout.line_items","line_item.price","line_item.fees","line_item.variant","variant.image","price.product","checkout.manual_payment_method","checkout.payment_method","checkout.selected_shipping_choice","shipping_choice.shipping_method","payment_method.card","payment_method.payment_instrument","payment_method.paypal_account","payment_method.bank_account","checkout.discount","discount.promotion","checkout.charge"]})})}renderLoading(){return h("sc-flex",{flexDirection:"column",style:{gap:"1em"}},h("sc-skeleton",{style:{width:"20%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"60%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"40%",display:"inline-block"}}))}renderEmpty(){return h("sc-empty",{icon:"shopping-bag"},__("Order not found.","surecart"))}renderContent(){var e,t,i,o,s,n,l,r;if(this.loading)return this.renderLoading();if(!(null===(e=this.order)||void 0===e?void 0:e.id))return this.renderEmpty();const a=null===(t=this.order)||void 0===t?void 0:t.checkout,d=null===(i=null==a?void 0:a.selected_shipping_choice)||void 0===i?void 0:i.shipping_method,c=null==d?void 0:d.name;return h(Fragment,null,((null===(o=null==a?void 0:a.line_items)||void 0===o?void 0:o.data)||[]).map((e=>{var t,i,o,s,n,l,r;return h("sc-product-line-item",{key:e.id,image:null==e?void 0:e.image,name:null===(i=null===(t=null==e?void 0:e.price)||void 0===t?void 0:t.product)||void 0===i?void 0:i.name,priceName:null===(o=null==e?void 0:e.price)||void 0===o?void 0:o.name,variantLabel:((null==e?void 0:e.variant_options)||[]).filter(Boolean).join(" / ")||null,editable:!1,removable:!1,quantity:e.quantity,scratchDisplayAmount:null==e?void 0:e.scratch_display_amount,displayAmount:null==e?void 0:e.subtotal_display_amount,amount:e.subtotal_amount,currency:null===(s=null==e?void 0:e.price)||void 0===s?void 0:s.currency,trialDurationDays:null===(n=null==e?void 0:e.price)||void 0===n?void 0:n.trial_duration_days,interval:intervalString(null==e?void 0:e.price),scratchAmount:null==e?void 0:e.scratch_amount,setupFeeTrialEnabled:null===(l=null==e?void 0:e.price)||void 0===l?void 0:l.setup_fee_trial_enabled,fees:null===(r=null==e?void 0:e.fees)||void 0===r?void 0:r.data})})),(null==a?void 0:a.subtotal_amount)!==(null==a?void 0:a.total_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Subtotal","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.subtotal_display_amount)),!!(null==a?void 0:a.trial_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Trial","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.trial_display_amount)),!!(null==a?void 0:a.discounts)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discounts","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.discounts_display)),!!(null===(n=null===(s=null==a?void 0:a.discount)||void 0===s?void 0:s.promotion)||void 0===n?void 0:n.code)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discount","surecart"),h("br",null),h("sc-tag",{type:"success"},__("Coupon:","surecart")," ",null===(r=null===(l=null==a?void 0:a.discount)||void 0===l?void 0:l.promotion)||void 0===r?void 0:r.code)),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.discounts_display_amount)),!!(null==a?void 0:a.shipping_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${__("Shipping","surecart")} ${c?`(${c})`:""}`),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.shipping_display_amount)),!!(null==a?void 0:a.tax_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${formatTaxDisplay(null==a?void 0:a.tax_label,"estimated"===(null==a?void 0:a.tax_status))} (${null==a?void 0:a.tax_percent}%)`),h("span",{slot:"price"},null==a?void 0:a.tax_display_amount),!!(null==a?void 0:a.tax_inclusive_amount)&&h("span",{slot:"price-description"},`(${__("included","surecart")})`)),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Total","surecart")),h("span",{slot:"price"},null==a?void 0:a.total_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),!!(null==a?void 0:a.proration_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Proration","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.proration_display_amount)),!!(null==a?void 0:a.applied_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Applied Balance","surecart")),h("span",{style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},slot:"price"},null==a?void 0:a.applied_balance_display_amount)),!!(null==a?void 0:a.credited_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Credited Balance","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.credited_balance_display_amount)),(null==a?void 0:a.amount_due)!==(null==a?void 0:a.total_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Amount Due","surecart")),h("span",{slot:"price"},null==a?void 0:a.amount_due_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),!!(null==a?void 0:a.paid_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Paid","surecart")),h("span",{slot:"price"},null==a?void 0:a.paid_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),!!(null==a?void 0:a.refunded_amount)&&h(Fragment,null,h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"description"},__("Refunded","surecart")),h("span",{slot:"price"},null==a?void 0:a.refunded_display_amount)),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Net Payment","surecart")),h("span",{slot:"price"},null==a?void 0:a.net_paid_display_amount))),(null==a?void 0:a.tax_reverse_charged_amount)>0&&h("sc-line-item",null,h("span",{slot:"description"},__("*Tax to be paid on reverse charge basis","surecart"))))}render(){var e,t,i,o,s,n,l;const r=null===(e=null==this?void 0:this.order)||void 0===e?void 0:e.checkout,a=null==r?void 0:r.manual_payment_method;return h("sc-spacing",{key:"94711abcc3d0c0a73390820286122a3b74de8412",style:{"--spacing":"var(--sc-spacing-large)"}},h("sc-dashboard-module",{key:"8312f13af42b46cb590ad0e0de1d9f8d92a5a2b2",error:this.error},h("span",{key:"a71fd21c6fcfd43b12d19581b457557b72f2c6c9",slot:"heading"},this.loading?h("sc-skeleton",{style:{width:"120px"}}):`#${null===(t=null==this?void 0:this.order)||void 0===t?void 0:t.number}`),!this.loading&&!(null==r?void 0:r.live_mode)&&h("sc-tag",{key:"bc1f3bf64b7d08fe38e1d87ec497fe7e44a5e6bd",type:"warning",slot:"end"},__("Test Mode","surecart")),!!(null==a?void 0:a.name)&&!!(null==a?void 0:a.instructions)&&h("sc-order-manual-instructions",{key:"1c42d93fd8467ba954934744a45da6e50149d397",manualPaymentTitle:null==a?void 0:a.name,manualPaymentInstructions:null==a?void 0:a.instructions}),h("sc-card",{key:"1844e0fc66fa66e09d063234dc593b60f40f3c33","no-padding":!this.loading},this.loading?this.renderLoading():h(Fragment,null,h("sc-stacked-list",null,h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Order Status","surecart")),h("sc-order-status-badge",{status:null===(i=null==this?void 0:this.order)||void 0===i?void 0:i.status})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Date","surecart")),h("span",null,null===(o=this.order)||void 0===o?void 0:o.created_at_date)),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Payment Method","surecart")),h("sc-payment-method",{paymentMethod:null==r?void 0:r.payment_method})),h("div",{class:"order__row"},this.renderContent()))))),(null===(s=this.order)||void 0===s?void 0:s.statement_url)&&h("sc-button",{key:"00303f51120687ac96045804601e0d4e273a93db",type:"primary",href:null===(n=this.order)||void 0===n?void 0:n.statement_url,target:"_blank"},h("sc-icon",{key:"5780b3a01015dec54dafc45476b3ac457493b70a",name:"inbox",slot:"prefix"}),__("Download Receipt/Invoice","surecart")),!!(null===(l=this.purchases)||void 0===l?void 0:l.length)&&h("sc-purchase-downloads-list",{key:"55a6ec1232aec5433f2482dc2788c11f321732f6",heading:__("Downloads","surecart"),purchases:this.purchases}))}static get is(){return"sc-order"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-order.scss"]}}static get styleUrls(){return{$:["sc-order.css"]}}static get properties(){return{orderId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"order-id",reflect:!1},customerIds:{type:"unknown",mutable:!1,complexType:{original:"string[]",resolved:"string[]",references:{}},required:!1,optional:!1,docs:{tags:[],text:""}},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"heading",reflect:!1}}}static get states(){return{order:{},purchases:{},loading:{},busy:{},error:{}}}static get elementRef(){return"el"}}